// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

#include <windows.h>
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#include "mpilib.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	HINSTANCE	hInst;
extern	HWND		hMainWindow;
extern	LPTSTR		lpszNA;
extern	LPCTSTR		lpIconPointer;
extern	LPCTSTR		lpszAppName;
extern	DWORD		dwN_Bits;
extern	DWORD		dwP_Bits;
extern	DWORD		dwQ_Bits;
extern	HWND		hDialogModeLess;
extern	HWND		hDlgCurrent;
extern	BOOL		bCancelOperation;
extern	HHOOK		hHook;
extern	HHOOK		hMouseHook;
extern	DWORD		dwElapHours;
extern	DWORD		dwElapMinutes;
extern	DWORD		dwElapSeconds;
extern	HWND		hStatusBar;
extern	NUMBERFMT	nFormatInfo;
extern	DWORD		dwCountBits;
extern	DWORD		dwCountBytes;
extern	DWORD		dwCountDwords;
extern	BYTE		Prime_P;
extern	DWORD		dwP_Bits;
extern	DWORD		dwP_Bytes;
extern	DWORD		dwP_Dwords;
extern	WORD		Prime_P_Mpi;
extern	BYTE		Prime_Q;
extern	DWORD		dwQ_Bits;
extern	DWORD		dwQ_Bytes;
extern	DWORD		dwQ_Dwords;
extern	WORD		Prime_Q_Mpi;
extern	BYTE		Temp1;
extern	BYTE		Temp2;
extern	BYTE		Temp3;
extern	HANDLE		hRBBThread;
extern	HANDLE		hDCTThread;
extern	BYTE		P_Temp;
extern	BYTE		Q_Temp;
extern	BYTE		E_Temp;
extern	BYTE		U_Temp;
extern	BYTE		D_Temp;
extern	WORD		D_Mpi;
extern	WORD		E_Mpi;
extern	WORD		Mod_N_Mpi;
extern	WORD		U_Mpi;
extern	DWORD		dwE_Bytes;
extern	DWORD		dwD_Bytes;
extern	DWORD		dwU_Bytes;
extern	DWORD		dwN_Bytes;
extern	BYTE		Modulus_N;
extern	BOOL		bProcessInProgress;
extern	int			iSkipCounter;
extern	int			iInitialSkipValue;
extern	DWORD		dwHelpTopicNumber;
extern	BOOL		bIsWinNT;
extern	BOOL		bAa;
extern	HFONT		hDlgFont;
extern	TCHAR		szTemp1[MAX_PATH];
extern	TCHAR		szTemp2[MAX_PATH];

// Key ring file names and variables.
//...................................
extern	HANDLE		hPublicKeyRing;
extern	HANDLE		hSecretKeyRing;
extern	BOOL		bKeyRingFilesLoaded;
extern	BOOL		bDisplayRingsOnStatusBar;
extern	TCHAR		szStatusBarRings[127];
extern	BOOL		bTimerOn;
extern	CONFIG		cfg;

#define	APPEND_LOADED	1
#define	LOAD_EXISTING	2
#define	CREATE_RINGS	3

// Variables for RSA key generation.
//..................................
TCHAR		szUserID[256];
int 		iLengthOfUserId;
DWORD		dwSeparationBits;
DWORD		dwValidityPeriod;
TCHAR		szPassPhrase1[250];
TCHAR		szPassPhrase2[250];
int			iLengthOfPassPhrase;
LPCTSTR		lpszNullString = "";
UINT		uTimer;
DWORD		dwFermatNumber;
DWORD		dwNumbersTested;
DWORD		dwFermatFail;
BOOL		bTestingPrimeP;
LPBYTE		lpPrimesTable;
LPBYTE		lpRemaindersTable;
BOOL		bRBBThreadSuspended;
BOOL		bDCTThreadSuspended;
BOOL		bBackupFiles;
DWORD		dwKeyGenPriority = NORMAL_PRIORITY_CLASS;
BYTE		TestEncrypt[] = "THE WRATH OF THE LAMB";
DWORD		dwTestEncryptBytes = 21;
BYTE		KeySID[KEY_ID_SIZE];
LPBYTE		lpKeyBuffer1;
LPBYTE		lpKeyBuffer2;
LPBYTE		lpKeyBuffer3;
LPBYTE		lpKeyBuffer4;

// Variables used in the writing of the key rings.
//................................................
DWORD		dwBytesToWrite;
DWORD		dwBytesToEncipher;
DWORD		dwPublicComp;
DWORD		dwSignatureSize;
DWORD		dwOurTimestamp;
DWORD		dwOurTimestamp1;
MD5_CTX		Md5Context;
BYTE		Md5Digest[16];
WORD		wMd5Byte1;
DWORD		dwTemp1Size;
DWORD		dwTemp1Bits;
DWORD		dwMpiCheckSum;

// Ask for key ring variable. 1 = use loaded set, 2 = load set,
// and 3 = create new set.
//.............................................................
DWORD		dwKeyRingsWhat;

// The number of key ring and index files active.
//...............................................
DWORD		dwKeyRingFilesActive = 0;

// Caption for rsa key generation dialog box.
//...........................................
TCHAR		szRsaCaption[] = "RSA Key Generation: Modulus n - %s Bits";
TCHAR		szUser[] = "User ID: ";
TCHAR		szDemoPublic[] = "Demo Public Key Ring.rng";
TCHAR		szDemoSecret[] = "Demo Secret Key Ring.rng";

// Rsa Key Generation for Top Secret Crypto.
//..........................................
BOOL RsaKeyGeneration()
{
	int				iDlgResult;
	TCHAR			cBuffer[128];
	BOOL			bGoodPrime;
	DWORD			dwCompareResult;
	DWORD			dwScratch;
	TCHAR			szBuffer[128];
	BOOL			bLoaded;
	BOOL			bCreated;
	DWORD			dwBytesWritten;
	LARGE_INTEGER	li;
	BOOL			bResult;
	LPBYTE			lpSecretComponents;
	DWORD			dwOldTopicNumber;
	unit			Remainder[MAX_UNIT_PRECISION];

	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;
	bBackupFiles = FALSE;

	// Clear all of the variables we will be using.
	//.............................................
	ClearAllVariables();

	// Setup the Help Topic Number for this procedure.
	//................................................
	dwOldTopicNumber = ChangeHelpTopic(IDH_MAKERSAKEYS);

	if (BPC())
	{
		goto CleanUp;
	}
	// Setup the Rsa key generation setup dialog box.
	//...............................................
	ZeroMemory(szPassPhrase1,sizeof(szPassPhrase1));
	ZeroMemory(szPassPhrase2,sizeof(szPassPhrase2));
	ZeroMemory(szUserID,sizeof(szUserID));
	iDlgResult = DialogBox(hInst,TEXT("RSAKEYSETUP"),hMainWindow,(DLGPROC)RsaKeySetupProc);

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iDlgResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto CleanUp;
	}
	// Quit if we canceled.
	//.....................
	if (iDlgResult == IDCANCEL)
	{
		goto CleanUp;
	}
	// Set our process to selected priority.
	//..............................
	SetPriorityClass(GetCurrentProcess(),dwKeyGenPriority);

	// If we have selected Realtime Priority disable the main window.
	//...............................................................
	if (dwKeyGenPriority == REALTIME_PRIORITY_CLASS)
	{
		EnableWindow(hMainWindow,FALSE);
	}
	// Setup the skip counters for the CheckForMessages function.
	//...........................................................
	__asm
	{
		mov		iSkipCounter,250
		mov		iInitialSkipValue,250
	}
	// Calculate the sizes of primes p and q.
	//.......................................
	__asm
	{
		mov		eax,dwN_Bits
		add		eax,dwSeparationBits
		shr		eax,1
		mov		dwQ_Bits,eax
		mov		eax,dwN_Bits
		sub		eax,dwQ_Bits
		mov		dwP_Bits,eax
	}
	// Set the precision for the RSA calculatins.
	//...........................................
	set_precision(bits2units(dwN_Bits+SLOP_BITS));

	// Setup a hook procedure to trap the tab key and mouse input.
	//............................................................
	hHook = SetWindowsHookEx(WH_KEYBOARD,(HOOKPROC)TrapTabKey,NULL,0);
	hMouseHook = SetWindowsHookEx(WH_MOUSE,(HOOKPROC)TrapMouseInput,
								  NULL,0);

	// Disply the progress information screen.
	//........................................
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("RSAKEYGEN"),hMainWindow,
								   (DLGPROC)RsaKeyGenProc);

	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto CleanUp;
	}
	// Display the number of bits for primes p and q.
	//...............................................
	DisplayPQBits();

	// Setup our elapsed timer.
	//.........................
	dwElapHours = 0;
	dwElapMinutes = 0;
	dwElapSeconds = 0;
	uTimer = SetTimer(hMainWindow,MY_TIMER,1000,
		             (TIMERPROC)My1SecondTimer);
	bTimerOn = TRUE;

	// Allocate memory for the primes and remainders tables.
	//......................................................
	lpPrimesTable = AllocateMemory(PRIMES_IN_TABLE*4);
	lpRemaindersTable = AllocateMemory(PRIMES_IN_TABLE*4);
	if (!lpPrimesTable || !lpRemaindersTable)
	{
		goto CleanUp;
	}
	// Create the primes table.
	//.........................
	LoadString(hInst,IDS_PRIMESTABLE,szBuffer,sizeof(szBuffer));
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,szBuffer);
	FillPrimeTable(lpPrimesTable,PRIMES_IN_TABLE);
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,lpszNullString);

	dwFermatNumber = -1;
	dwNumbersTested = 0;
	dwFermatFail = 0;
	bTestingPrimeP = TRUE;

	// Highlight the search for Prime p checkbox.
	//...........................................
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_PRIMEPSEARCH),TRUE);

	// Get Prime p.
	//.............
	bGoodPrime = GetRandomPrimeNumber(&Prime_P,dwP_Bits);
	
	// If we quit, or we could not find a good prime.
	//...............................................
	if (!bGoodPrime)
	{
		if (!bCancelOperation)
		{
			SendMessage(hDialogModeLess,WM_COMMAND,IDCANCEL,0);
		}
		goto CleanUp; 
	}
	// We found a good Prime p.
	//.........................
	CheckDlgButton(hDialogModeLess,IDC_PRIMEPSEARCH,BST_CHECKED);
	dwP_Bits = dwCountBits;
	dwP_Bytes = dwCountBytes;
	dwP_Dwords = dwCountDwords;
	__asm
	{
		mov		eax,dwP_Bits
		xchg	ah,al
		mov		Prime_P_Mpi,ax
	}
	// Recalculate bits for Prime q to be sure.
	//.........................................
	dwQ_Bits = dwN_Bits;
	dwQ_Bits -= dwP_Bits;
	FormatMyNumber(dwQ_Bits,(LPTSTR)&cBuffer,sizeof(cBuffer));
	SetDlgItemText(hDialogModeLess,IDC_PRIMEQBITS,cBuffer);

	// Setup for finding Prime q.
	//...........................
	dwFermatNumber = -1;
	dwNumbersTested = 0;
	dwFermatFail = 0;
	bTestingPrimeP = FALSE;
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_PRIMEQSEARCH),TRUE);

	// Keep trying q's until we get one that is far enough apart from p.
	//..................................................................
	while (TRUE)
	{
		bGoodPrime = GetRandomPrimeNumber(&Prime_Q,dwQ_Bits);

		// If we quit, or we could not find a good prime.
		//...............................................
		if (!bGoodPrime)
		{
			if (!bCancelOperation)
			{
				SendMessage(hDialogModeLess,WM_COMMAND,IDCANCEL,0);
			}
			goto CleanUp; 
		}
		dwQ_Bits = dwCountBits;
		dwQ_Bytes = dwCountBytes;
		dwQ_Dwords = dwCountDwords;
		__asm
		{
			mov		eax,dwQ_Bits
			xchg	ah,al
			mov		Prime_Q_Mpi,ax
		}
		// Make sure that p is less than q. If not, swap them.
		//....................................................
		dwCompareResult = MpCompareDW(&Prime_Q,&Prime_P,MAX_PRIME_DWORD);
		if(dwCompareResult == 1)
		{
			SwapOps(&Prime_P,&Prime_Q,MAX_PRIME_SLOP);
			__asm
			{
				mov		eax,dwP_Bits
				mov		edx,dwQ_Bits
				mov		dwP_Bits,edx
				mov		dwQ_Bits,eax

				mov		eax,dwP_Bytes
				mov		edx,dwQ_Bytes
				mov		dwP_Bytes,edx
				mov		dwQ_Bytes,eax

				mov		eax,dwP_Dwords
				mov		edx,dwQ_Dwords
				mov		dwP_Dwords,edx
				mov		dwQ_Dwords,eax

				mov		ax,Prime_P_Mpi
				mov		dx,Prime_Q_Mpi
				mov		Prime_P_Mpi,dx
				mov		Prime_Q_Mpi,ax
			}
			// Display the new numbers in the dialog box.
			//...........................................
			DisplayPQBits();
		}
		// Make sure that the primes are far enough apart. If not,
		// keep trying q's until they are far enough apart.
		//........................................................
		CopyMemory(&Temp1,&Prime_Q,MAX_PRIME_SLOP);
		MpSubDW(&Temp1,&Prime_P,MAX_PRIME_DWORD);
		CountBBD(&Temp1,MAX_PRIME_BYTES);
		dwScratch = dwQ_Bits;
		dwScratch -= 7;
		if (dwCountBits >= dwScratch)
		{
			break;
		}
		// They are not far enough apart.
		//...............................
		dwQ_Bits = dwN_Bits;
		dwQ_Bits -= dwP_Bits;

		DisplayPQBits();
		dwFermatNumber = -1;
		PrimeQFermatProgress();
	}
	// We have found a good Prime q. Start on Phi(n).
	//...............................................
	CheckDlgButton(hDialogModeLess,IDC_PRIMEQSEARCH,BST_CHECKED);
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_PHIN),TRUE);

	// Destroy some evidence of our key generation.
	//.............................................
	ZeroMemory(lpPrimesTable,PRIMES_IN_TABLE*4);
	bResult = DeallocateMemory(lpPrimesTable);
	if (!bResult)
	{
		goto CleanUp;
	}
	lpPrimesTable = 0;
	ZeroMemory(lpRemaindersTable,PRIMES_IN_TABLE*4);
	bResult = DeallocateMemory(lpRemaindersTable);
	if (!bResult)
	{
		goto CleanUp;
	}
	lpRemaindersTable = 0;

	// Clear some variables for our use.
	//..................................
	ClearEncVariables();
	ZeroMemory(&P_Temp,MAX_PRIME_SLOP);
	ZeroMemory(&Q_Temp,MAX_PRIME_SLOP);
	ZeroMemory(&E_Temp,MAX_MOD_SLOP);
	ZeroMemory(&U_Temp,MAX_MOD_SLOP);
	ZeroMemory(&D_Temp,MAX_MOD_SLOP);

	// Transfer primes p and q to temporary variables.
	//................................................
	CopyMemory(&P_Temp,&Prime_P,dwP_Bytes);
	CopyMemory(&Q_Temp,&Prime_Q,dwQ_Bytes);
	
	// Decrement p and q.
	//...................
	mp_dec((unitptr)&P_Temp);
	mp_dec((unitptr)&Q_Temp);

	// Phi(n) = (p-1)*(q-1). Phi(n) is the totient function of n, or
	// the number of positive integers less than n that are relatively
	// prime to n.
	//................................................................
	mp_dmul((unitptr)&Temp2,(unitptr)&Q_Temp,(unitptr)&P_Temp);

	// Mark Phi(n) as found. Saved in Temp2.
	//......................................
	CheckDlgButton(hDialogModeLess,IDC_PHIN,BST_CHECKED);
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_GN),TRUE);

	CheckForMessages();
	if (bCancelOperation)
	{
		goto CleanUp;
	}
	// Display message that G(n) will take awhile.
	//............................................
	LoadString(hInst,IDS_GNLONGTIME,szBuffer,sizeof(szBuffer));
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,szBuffer);

	// G(n) = GCD(p-1, q-1). G is the number of "spare key sets" for
	// a given modulus n. The smaller G is, the better. The smallest
	// G can get is 2. (GCD means greatest common divisor.) G(n)
	// returned in Temp1.
	//..............................................................
	mp_gcd((unitptr)&Temp1,(unitptr)&P_Temp,(unitptr)&Q_Temp);

	// Mark G(n) as found.
	//....................
	CheckDlgButton(hDialogModeLess,IDC_GN,BST_CHECKED);
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,lpszNullString);
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_FN),TRUE);

	// Temp1 = G(n) and Temp2 = Phi(n). Calculate F(n) and put in Temp3.
	//..................................................................
	mp_udiv((unitptr)&Remainder,(unitptr)&Temp3,(unitptr)&Temp2,(unitptr)&Temp1);

	CheckDlgButton(hDialogModeLess,IDC_FN,BST_CHECKED);
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_EXPONENTE),TRUE);

	CheckForMessages();
	if (bCancelOperation)
	{
		goto CleanUp;
	}
	// Look for an e such that GCD(e, Phi(n)) = 1. We will start
	// with an e equal to 17 and try odd e's until we find the 
	// one we want. e should never get over 8 bytes long. e
	// returned in E_Temp. GCD in Temp1.
	//..........................................................
	__asm
	{
		mov		edi,offset E_Temp
		mov		dword ptr [edi],15	// Adjust for preincrements
	}
	CountBBD(&Temp2,MAX_MOD_BYTES);
	dwScratch = dwCountBytes;
	while(TRUE)
	{
		mp_inc((unitptr)&E_Temp);
		mp_inc((unitptr)&E_Temp);
		mp_gcd((unitptr)&Temp1,(unitptr)&E_Temp,(unitptr)&Temp2);

		CheckForMessages();
		if (bCancelOperation)
		{
			goto CleanUp;
		}
		// Test Temp1 for 1.
		//..................
		CountBBD(&Temp1,dwCountBytes);
		
		if (dwCountBits = 1)
		{
			break;
		}
	}
	// Count the bits and bytes in the final e.
	//.........................................
	CountBBD(&E_Temp,MAX_PRIME_BYTES);
	__asm
	{
		mov		eax,dwCountBits
		xchg	ah,al
		mov		E_Mpi,ax
	}
	dwE_Bytes = dwCountBytes;

	CheckDlgButton(hDialogModeLess,IDC_EXPONENTE,BST_CHECKED);
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_EXPONENTD),TRUE);

	// Calculate d which is the multiplicative inverse of e and 
	// F(n). Compute d such that (e*d) mod F(n) = 1. Returns d
	// in D_Temp. It will always be a positive number.
	//.........................................................
	mp_inv((unitptr)&D_Temp,(unitptr)&E_Temp,(unitptr)&Temp3);

	CheckForMessages();
	if (bCancelOperation)
	{
		goto CleanUp;
	}

	CountBBD(&D_Temp,MAX_MOD_BYTES);
	__asm
	{
		mov		eax,dwCountBits
		xchg	ah,al
		mov		D_Mpi,ax
	}
	dwD_Bytes = dwCountBytes;

	CheckDlgButton(hDialogModeLess,IDC_EXPONENTD,BST_CHECKED);
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_INVERSEU),TRUE);

	// State that Inverse U will take a while.
	//........................................
	LoadString(hInst,IDS_INVERSELONGTIME,szBuffer,sizeof(szBuffer));
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,szBuffer);

	// Calculate u, the multiplicative inverse of p and q.
	// Compute u such that (p*u) mod q = 1. p < q. Returns
	// u in U_Temp.
	//.....................................................
	mp_inv((unitptr)&U_Temp,(unitptr)&Prime_P,(unitptr)&Prime_Q);

	CountBBD(&U_Temp,MAX_MOD_BYTES);
	__asm
	{
		mov		eax,dwCountBits
		xchg	ah,al
		mov		U_Mpi,ax
	}
	dwU_Bytes = dwCountBytes;

	// Mark u as found. Save in U_Temp.
	//.................................
	CheckDlgButton(hDialogModeLess,IDC_INVERSEU,BST_CHECKED);
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,lpszNullString);
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_MODULUSN),TRUE);
	
	CheckForMessages();
	if (bCancelOperation)
	{
		goto CleanUp;
	}
	// Calculate Modulus n which is the product of p and q.
	//.....................................................
	mp_dmul((unitptr)&Modulus_N,(unitptr)&Prime_Q,(unitptr)&Prime_P);

	CountBBD(&Modulus_N,MAX_MOD_BYTES);
	__asm
	{
		mov		eax,dwCountBits
		xchg	ah,al
		mov		Mod_N_Mpi,ax
	}
	dwN_Bytes = dwCountBytes;

	// Mark n as found, save in Modulus_N.
	//....................................
	CheckDlgButton(hDialogModeLess,IDC_MODULUSN,BST_CHECKED);
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_TESTRSAKEYS),TRUE);

	// Destroy a lot of the evidence.
	//...............................
	ClearEncVariables();

	CheckForMessages();
	if (bCancelOperation)
	{
		goto CleanUp;
	}
	// Inform that rsa key test calculations could take awhile.
	//.........................................................
	LoadString(hInst,IDS_RSATESTWAIT,(LPTSTR)&szBuffer,sizeof(szBuffer));
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,(LPCTSTR)&szBuffer);

	// It is now time to test the Rsa Keys.
	//.....................................
	RsaPriEnc(&Temp1,(LPBYTE)&TestEncrypt,lstrlen(TestEncrypt),&D_Temp,
			  &Prime_P,&Prime_Q,&U_Temp,dwN_Bytes);

	CheckForMessages();
	if (bCancelOperation)
	{
		goto CleanUp;
	}
	// Now decrypt using RsaPubDec.
	//.............................
	ClearDecryptVariables();
	RsaPubDec(&Temp2,&Temp1,&E_Temp,&Modulus_N,dwN_Bytes);

	CheckForMessages();
	if (bCancelOperation)
	{
		goto CleanUp;
	}

	// If dwCountBytes is not equal to the length of the 
	// test string we have an error.
	//..................................................
	dwCompareResult = -1;		// The test always fails.

	if (dwCountBytes == (DWORD)lstrlen(TestEncrypt))
	{
		__asm
		{
			mov		edi,offset TestEncrypt
			mov		esi,offset Temp2
			mov		ecx,dwCountBytes
			repe	cmpsb
			jnz		L1
			mov		dwCompareResult,0
		L1:
		}
	}
	// Reset the programs priority if needed.
	//.......................................
	ResetProgramPriority();

	// If the test is not successful.
	//...............................
	if (dwCompareResult != 0)
	{
		MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_KEYSFAILEDTEST,
					   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
		goto CleanUp;
	}
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,lpszNullString);

	// Mark the test as successful.
	//.............................
	CheckDlgButton(hDialogModeLess,IDC_TESTRSAKEYS,BST_CHECKED);

	// Change Modulus n and Exponent e to MSB - LSB format.
	//.....................................................
	CircleSwap(&E_Temp,dwE_Bytes);
	CircleSwap(&Modulus_N,dwN_Bytes);

	// Get and save the 8 byte Key ID for our signature.
	//..................................................
	__asm
	{
		mov		esi,offset Modulus_N
		add		esi,dwN_Bytes
		sub		esi,KEY_ID_SIZE
		mov		eax,dword ptr [esi]
		mov		edx,dword ptr [esi+4]
		mov		dword ptr KeySID,eax
		mov		dword ptr KeySID[4],edx
	}
	// Allocate memory for building our keys.
	//.......................................
	lpKeyBuffer1 = AllocateMemory(SIZE_BUILD_BUFF);
	lpKeyBuffer2 = AllocateMemory(SIZE_BUILD_BUFF);
	if (!lpKeyBuffer1 || !lpKeyBuffer2)
	{
		goto CleanUp;
	}
	// Flash our task bar icon if it is minimized.
	//............................................
	FlashMyIcon(TRUE);

	// Check where we want to save our new keys to.
	//.............................................
	iDlgResult = DialogBox(hInst,TEXT("ASKKEYRINGS"),hMainWindow,(DLGPROC)AskForKeyRings);

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iDlgResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto CleanUp;
	}
	// Quit if we canceled.
	//.....................
	if (iDlgResult == IDCANCEL)
	{
		goto CleanUp;
	}
	// If we want to load another set of key rings.
	//.............................................
	if (dwKeyRingsWhat == LOAD_EXISTING)
	{
		// If we have a set of key rings already loaded we have to 
		// close them.
		//........................................................
		bResult = CloseAllKeyRingFiles();
		if (!bResult)
		{
			goto CleanUp;
		}
		bLoaded = LoadASetOfKeyRings(TRUE,TRUE,hDialogModeLess);
			
		if (!bLoaded)
		{
			goto CleanUp;
		}
	}
	else if (dwKeyRingsWhat == CREATE_RINGS)
	{
		// Create a new set of key rings.
		//...............................
		bCreated = CreateANewSetOfKeyRings();

		if (!bCreated)
		{
			goto CleanUp;
		}
	}
	// Change the text and Disable the cancel button in the dialog box.
	//.................................................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));
	EnableWindow(GetDlgItem(hDialogModeLess,IDCANCEL),FALSE);

	// When we get to here, the key rings are loaded or created,
	// with their handles in their respective variables.
	// Start creating the public key with the owners signature.
	//..........................................................
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_CREATEOWNERSIG),TRUE);

	__asm
	{
		mov		edi,lpKeyBuffer1
		mov		al,CTB_PUBLIC_KEY
		or		al,LENGTH_2
		stosb

		// Calculate the length of the whole key. First add in the
		// number of bytes before the mpi's. ctb, length, version,
		// timestamp, validity, algorithm, and 2 mpi prefixes.
		//.........................................................
		mov		eax,PUBKEY_HDR_SIZE
		add		eax,dwN_Bytes
		add		eax,dwE_Bytes
		mov		dwBytesToWrite,eax
		mov		dwPublicComp,eax		// First part of secret key

		// Length byte does not include CTB and length field.
		//...................................................
		sub		eax,3
		xchg	ah,al
		stosw
		mov		al,VERSION_NEW
		stosb
		push	edi
	}
	// Get the GMT timestamp for the public key.
	// Timestamp returned in edx:eax.
	//..........................................
	GetTimestamp(TRUE);

	__asm
	{
		pop		edi
		bswap	eax
		stosd
		mov		eax,dwValidityPeriod
		xchg	ah,al
		stosw
		mov		al,RSA_ALGORITHM

		// Put in the high 7 bits of the timestamp into the algorithm byte.
		//.................................................................
		shl		dl,1
		or		al,dl
		stosb
		mov		ax,Mod_N_Mpi
		stosw
		mov		esi,offset Modulus_N
		mov		ecx,dwN_Bytes
		rep		movsb

		// Transfer Exponent e to the buffer.
		//...................................
		mov		ax,E_Mpi
		stosw
		mov		esi,offset E_Temp
		mov		ecx,dwE_Bytes
		rep		movsb

		// Add a keyring trust packet saying we made it.
		//..............................................
		add		dwBytesToWrite,3
		mov		al,CTB_TRUST
		or		al,LENGTH_1
		stosb
		mov		al,1
		stosb
		mov		al,ON_SECRET_RING
		or		al,BUCKSTOP_BIT
		stosb

		// Add the user id to the public key.
		//...................................
		add		dwBytesToWrite,2
		mov		ecx,iLengthOfUserId
		add		dwBytesToWrite,ecx
		mov		al,CTB_USER_ID
		or		al,LENGTH_1
		stosb
		mov		eax,ecx
		stosb
		mov		esi,offset szUserID
		rep		movsb

		// Now add a trust packet for the user id.
		//........................................
		add		dwBytesToWrite,3
		mov		al,CTB_TRUST
		or		al,LENGTH_1
		stosb
		mov		al,1
		stosb
		mov		al,UID_COMPL_TRUST
		stosb
	}
	// Inform that signature calculations could take awhile.
	//......................................................
	LoadString(hInst,IDS_SIGSTAKEAWHILE,(LPTSTR)&szBuffer,sizeof(szBuffer));
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,(LPCTSTR)&szBuffer);

	// Create the Owner's Signature for this public key
	// and User Id.
	//.................................................
	SignMyKey(KEY_CERT_SELF);

	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,lpszNullString);

	CheckDlgButton(hDialogModeLess,IDC_CREATEOWNERSIG,BST_CHECKED);
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_WRITEPUBLICKEY),TRUE);

	// Append the new key to the end of the public ring file.
	//.......................................................
	li.QuadPart = SetMyFilePointer((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,0,FILE_END);
	if (li.QuadPart == -1)
	{
		goto CleanUp;
	}

	bResult = WriteMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,
		                   lpKeyBuffer1,dwBytesToWrite,&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto CleanUp;
	}
	// Add the signature to the end of the key.
	//.........................................
	bResult = WriteMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,
		                   lpKeyBuffer2,dwSignatureSize,&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto CleanUp;
	}

	CheckDlgButton(hDialogModeLess,IDC_WRITEPUBLICKEY,BST_CHECKED);
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_WRITESECRETKEY),TRUE);

	// Change the rest of the variables to msb to lsb.
	//................................................
	CircleSwap(&D_Temp,dwD_Bytes);
	CircleSwap(&Prime_P,dwP_Bytes);
	CircleSwap(&Prime_Q,dwQ_Bytes);
	CircleSwap(&U_Temp,dwU_Bytes);

	// Calculate the Mpi Checksum for d, p, q, and u for the
	// secret key.
	//......................................................
	dwMpiCheckSum = 0;
	dwMpiCheckSum += CheckSum((LPBYTE)&D_Mpi,2);
	dwMpiCheckSum += CheckSum(&D_Temp,dwD_Bytes);
	dwMpiCheckSum += CheckSum((LPBYTE)&Prime_P_Mpi,2);
	dwMpiCheckSum += CheckSum(&Prime_P,dwP_Bytes);
	dwMpiCheckSum += CheckSum((LPBYTE)&Prime_Q_Mpi,2);
	dwMpiCheckSum += CheckSum(&Prime_Q,dwQ_Bytes);
	dwMpiCheckSum += CheckSum((LPBYTE)&U_Mpi,2);

	if (dwU_Bytes == 0)
	{
		MessageBox(hMainWindow,TEXT("Bug 10"),TEXT("Bug Report"),MB_OK);
	}
	dwMpiCheckSum += CheckSum(&U_Temp,dwU_Bytes);

	// Convert to msb to lsb.
	//.......................
	__asm
	{
		mov		eax,dwMpiCheckSum
		xchg	ah,al
		mov		dwMpiCheckSum,eax

		// Write the secret key to disk. We can do it in two sections.
		// The first section of the secret key is the same as the
		// public key. Just change the CTB byte and the length bytes.
		//............................................................
		mov		edi,lpKeyBuffer1
		mov		al,CTB_SECRET_KEY
		or		al,LENGTH_2
		stosb
		mov		eax,dwPublicComp	// Length of public key.
		sub		eax,3				// Not CTB or length field.

		// Add in the length of the algorithm byte, cipher feedback
		// if required, 4 mpi prefixes, 4 mpi's, and a 16 bit
		// checksum.
		//.........................................................
		add		eax,ALGORITHM_SIZE
		cmp		iLengthOfPassPhrase,0
		je		L2
		add		eax,CFB_LENGTH
	L2:	add		eax,((4*MPI_PREFIX_SIZE) + CHECKSUM_SIZE)
		add		eax,dwD_Bytes
		add		eax,dwP_Bytes
		add		eax,dwQ_Bytes
		add		eax,dwU_Bytes
		xchg	ah,al
		stosw
	}
	// Append the new secret key to the end of the secret key ring.
	// Write the first section of the secret key.
	//.............................................................
	li.QuadPart = SetMyFilePointer((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,0,FILE_END);
	if (li.QuadPart == -1)
	{
		goto CleanUp;
	}

	bResult = WriteMyFile((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,
		                   lpKeyBuffer1,dwPublicComp,&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto CleanUp;
	}
	// Now lets do the secret parts of the secret key.
	//................................................
	ZeroMemory(lpKeyBuffer1,SIZE_BUILD_BUFF);
	
	__asm
	{
		mov		dwBytesToWrite,0
		mov		edi,lpKeyBuffer1
		inc		dwBytesToWrite

		// Assume no encryption.
		//......................
		mov		al,NO_ENCRYPTION
		cmp		iLengthOfPassPhrase,0
		je		L3
		mov		al,TSC_ALGORITHM
	L3:	stosb
		mov		lpSecretComponents,edi
	}
	// Get our 8 bytes of random bits for hiding the secret
	// key components.
	//.....................................................
	if (iLengthOfPassPhrase)
	{
		GetRandomBits((CFB_LENGTH*8),lpSecretComponents);
		dwBytesToWrite += 8;
		lpSecretComponents += 8;
	}
	// Transfer Exponent d to the secret key.
	//.......................................
	__asm
	{
		mov		edi,lpSecretComponents
		add		dwBytesToWrite,2
		mov		dwBytesToEncipher,2
		mov		ax,D_Mpi
		stosw
		mov		ecx,dwD_Bytes
		add		dwBytesToWrite,ecx
		add		dwBytesToEncipher,ecx
		mov		esi,offset D_Temp
		rep		movsb

		// Transfer Prime p to the secret key.
		//....................................
		mov		ax,Prime_P_Mpi
		stosw
		add		dwBytesToWrite,2
		add		dwBytesToEncipher,2
		mov		ecx,dwP_Bytes
		add		dwBytesToWrite,ecx
		add		dwBytesToEncipher,ecx
		mov		esi,offset Prime_P
		rep		movsb

		// Transfer Prime q to the secret key.
		//....................................
		mov		ax,Prime_Q_Mpi
		stosw
		add		dwBytesToWrite,2
		add		dwBytesToEncipher,2
		mov		ecx,dwQ_Bytes
		add		dwBytesToWrite,ecx
		add		dwBytesToEncipher,ecx
		mov		esi,offset Prime_Q
		rep		movsb

		// Transfer Inverse u to the secret key.
		//......................................
		mov		ax,U_Mpi
		stosw
		add		dwBytesToWrite,2
		add		dwBytesToEncipher,2
		mov		ecx,dwU_Bytes
		add		dwBytesToWrite,ecx
		add		dwBytesToEncipher,ecx
		mov		esi,offset U_Temp
		rep		movsb

		// Now transfer the 16 bit checksum.
		//..................................
		add		dwBytesToWrite,CHECKSUM_SIZE
		add		dwBytesToEncipher,CHECKSUM_SIZE
		mov		eax,dwMpiCheckSum
		stosw
		push	edi
	}
	// If we have to encrypt the secret components do it here.
	//........................................................
	if (iLengthOfPassPhrase)
	{
		EncipherSecretComponents((LPBYTE)&szPassPhrase1,lpSecretComponents,
								 (DWORD)iLengthOfPassPhrase,dwBytesToEncipher);
	}
	// Now add the User Id to the end of the secret key.
	//..................................................
	__asm
	{
		pop		edi
		add		dwBytesToWrite,(CTB_SIZE + 1)
		mov		al,CTB_USER_ID
		or		al,LENGTH_1
		stosb
		mov		ecx,iLengthOfUserId
		mov		eax,ecx
		stosb
		add		dwBytesToWrite,ecx
		mov		esi,offset szUserID
		rep		movsb
	}
	// Write the final section of the secret key to disk.
	//...................................................
	bResult = WriteMyFile((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,
		                   lpKeyBuffer1,dwBytesToWrite,&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto CleanUp;
	}

	CheckDlgButton(hDialogModeLess,IDC_WRITESECRETKEY,BST_CHECKED);

	if (uTimer)
	{
		KillTimer(hMainWindow,MY_TIMER);
		uTimer = 0;
	}
	// Deallocate the memory buffers. They are used in checking the key ring.
	//.......................................................................
	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,SIZE_BUILD_BUFF);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (lpKeyBuffer2)
	{
		ZeroMemory(lpKeyBuffer2,SIZE_BUILD_BUFF);
		DeallocateMemory(lpKeyBuffer2);
		lpKeyBuffer2 = 0;
	}
	// Index or reindex the public and secret key rings.
	//..................................................
	bResult = IndexKeyRingFiles(hDialogModeLess);
	if (!bResult)
	{
		goto CleanUp;
	}

	EmptyTheMessageQue();

	// If we have six active key ring and index files, enable
	// the menu items.
	//.......................................................
	if (dwKeyRingFilesActive == 6)
	{
		bKeyRingFilesLoaded = TRUE;
		EnableAllMenuItems(TRUE);
	}
	// Check out the key rings.
	//.........................
	if (bKeyRingFilesLoaded)
	{
		bResult = CheckOutTheKeyRings(TRUE,hDialogModeLess);
		if (!bResult)
		{
			goto CleanUp;
		}
		KeyRingsForStatusBar();

		EmptyTheMessageQue();

		// Set the backup flag.
		//.....................
		bBackupFiles = TRUE;
	}
	// We are done writting the keys to disk. Enable the OK button.
	//.............................................................
	LoadString(hInst,IDS_RSAGENCOMPLETE,(LPTSTR)&szBuffer,sizeof(szBuffer));
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,(LPCTSTR)&szBuffer);
	EnableWindow(GetDlgItem(hDialogModeLess,IDCANCEL),TRUE);
	SetFocus(GetDlgItem(hDialogModeLess,IDCANCEL));

	// Flash our task bar icon if it is minimized.
	//............................................
	FlashMyIcon(TRUE);

	while(TRUE)
	{
		CheckForMessages();

		if (bCancelOperation == TRUE)
			break;
	}
	// Clean up after ourselves.
	//..........................
	CleanUp:

	FlashMyIcon(FALSE);

	ClearAllVariables();

	ResetProgramPriority();

	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	// If our RBB thread is still suspeneded, resume its execution.
	//.............................................................
	if (bRBBThreadSuspended)
	{
		ResumeThread(hRBBThread);
		bRBBThreadSuspended = FALSE;
	}
	if (bDCTThreadSuspended)
	{
		ResumeThread(hDCTThread);
		bDCTThreadSuspended = FALSE;
	}
	if (uTimer)
	{
		KillTimer(hMainWindow,MY_TIMER);
		uTimer = 0;
	}
	bTimerOn = FALSE;

	// Reset the status bar to ready.
	//...............................
	if (bDisplayRingsOnStatusBar)
	{
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szStatusBarRings);
	}
	else
	{
		LoadString(hInst,IDS_READY,cBuffer,sizeof(cBuffer));
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)cBuffer);
	}
	if (hHook)
	{
		UnhookWindowsHookEx(hHook);
		hHook = 0;
	}
	if (hMouseHook)
	{
		UnhookWindowsHookEx(hMouseHook);
		hMouseHook = 0;
	}
	ZeroMemory(szPassPhrase1,sizeof(szPassPhrase1));
	ZeroMemory(szPassPhrase2,sizeof(szPassPhrase2));
	ZeroMemory(szUserID,sizeof(szUserID));

	// Deallocate our memory.
	//.......................
	if (lpPrimesTable)
	{
		ZeroMemory(lpPrimesTable,PRIMES_IN_TABLE*4);
		DeallocateMemory(lpPrimesTable);
		lpPrimesTable = 0;
	}
	if (lpRemaindersTable)
	{
		ZeroMemory(lpRemaindersTable,PRIMES_IN_TABLE*4);
		DeallocateMemory(lpRemaindersTable);
		lpRemaindersTable = 0;
	}
	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,SIZE_BUILD_BUFF);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (lpKeyBuffer2)
	{
		ZeroMemory(lpKeyBuffer2,SIZE_BUILD_BUFF);
		DeallocateMemory(lpKeyBuffer2);
		lpKeyBuffer2 = 0;
	}
	EmptyTheMessageQue();

	ChangeHelpTopic(dwOldTopicNumber);
	bCancelOperation = FALSE;
	bProcessInProgress = FALSE;

	return(TRUE);
}

// CALLBACK procedure for the Rsa Key Generation dialog box.
//..........................................................
LRESULT CALLBACK RsaKeyGenProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			TCHAR		szNumber[12];
			TCHAR		szBuffer[264];
			LPBYTE		lpTemp;

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Set the IDC_MESSAGE control to bold.
			//.....................................
			SetBoldFont(hDlg,IDC_MESSAGE,0);

			// Setup the caption bar.
			//.......................
			FormatMyNumber(dwN_Bits,(LPTSTR)&szNumber,sizeof(szNumber));
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szRsaCaption,szNumber);
			SendMessage(hDlg,WM_SETTEXT,0,(LPARAM)(LPCTSTR)szBuffer);

			// Setup the user id display.
			//...........................
			ZeroMemory(&szBuffer,sizeof(szBuffer));
			CopyMemory(&szBuffer,&szUser,9);
			lpTemp = (LPBYTE)&szBuffer;
			lpTemp += 9;
			CopyMemory(lpTemp,&szUserID,40);
			SetDlgItemText(hDlg,IDC_IDOFUSER,(LPCTSTR)&szBuffer);
			
			// Setup the initial values for primes p and q bits.
			//..................................................
			DisplayPQBits();

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			if (hDlgFont)
			{
				DeleteObject(hDlgFont);
				hDlgFont = 0;
			}
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Display the bits for primes p and q in the dialog box.
//.......................................................
VOID DisplayPQBits()
{
	TCHAR	cBuffer[128];

	FormatMyNumber(dwP_Bits,(LPTSTR)&cBuffer,sizeof(cBuffer));
	SetDlgItemText(hDialogModeLess,IDC_PRIMEPBITS,cBuffer);

	FormatMyNumber(dwQ_Bits,(LPTSTR)&cBuffer,sizeof(cBuffer));
	SetDlgItemText(hDialogModeLess,IDC_PRIMEQBITS,cBuffer);
}

// CALLBACK procedure for the AskForKeyRings dialog box.
//......................................................
LRESULT CALLBACK AskForKeyRings(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	LPBYTE			lpFileDemo;
	int				iCmpPublic;
	int				iCmpSecret;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the condition of our three radiobuttons.
			//...............................................
			if (!bKeyRingFilesLoaded)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_LOADED),FALSE);

				// Check the new radio button.
				//............................
				CheckRadioButton(hDlg,IDC_LOADED,IDC_NEWRINGS,IDC_NEWRINGS);
				dwKeyRingsWhat = CREATE_RINGS;
			}
			else
			{
				// Check for demo key rings. Cannot add keys to it.
				//.................................................
				lpFileDemo = PathFindFileName((LPCTSTR)&cfg.szPublicKeyRing);
				iCmpPublic = CompareString(LOCALE_USER_DEFAULT,NORM_IGNORECASE,
										  (LPCTSTR)lpFileDemo,-1,(LPCTSTR)&szDemoPublic,-1);
				lpFileDemo = PathFindFileName((LPCTSTR)&cfg.szSecretKeyRing);
				iCmpSecret = CompareString(LOCALE_USER_DEFAULT,NORM_IGNORECASE,
										  (LPCTSTR)lpFileDemo,-1,(LPCTSTR)&szDemoSecret,-1);
				if (iCmpPublic == CSTR_EQUAL || iCmpSecret == CSTR_EQUAL)
				{
					EnableWindow(GetDlgItem(hDlg,IDC_LOADED),FALSE);

					// Check the new radio button.
					//............................
					CheckRadioButton(hDlg,IDC_LOADED,IDC_NEWRINGS,IDC_NEWRINGS);
					dwKeyRingsWhat = CREATE_RINGS;
				}
				else
				{
					// Check the loaded radio button.
					//...............................
					CheckRadioButton(hDlg,IDC_LOADED,IDC_NEWRINGS,IDC_LOADED);
					dwKeyRingsWhat = APPEND_LOADED;
				}
			}
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_LOADED:
				{
					CheckRadioButton(hDlg,IDC_LOADED,IDC_NEWRINGS,IDC_LOADED);
					dwKeyRingsWhat = APPEND_LOADED;
				}
				break;

				case IDC_LOAD:
				{
					CheckRadioButton(hDlg,IDC_LOADED,IDC_NEWRINGS,IDC_LOAD);
					dwKeyRingsWhat = LOAD_EXISTING;
				}
				break;

				case IDC_NEWRINGS:
				{
					CheckRadioButton(hDlg,IDC_LOADED,IDC_NEWRINGS,IDC_NEWRINGS);
					dwKeyRingsWhat = CREATE_RINGS;
				}
				break;

				case IDOK:
				{
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for the Rsa Key Generation Setup dialog box.
//................................................................
LRESULT CALLBACK RsaKeySetupProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	int			iCompareResult;
	HWND		hMyBuddy2;
	HWND		hMyBuddy3;
	HWND		hMyBuddy4;
	HWND		hSpinBox2;
	HWND		hSpinBox3;
	HWND		hSpinBox4;
	DWORD		dwStyle;
	BOOL		bError;
	DWORD		dwLengthPP2;
	BYTE		AllEqual;
	int			i;
	DWORD		dwV;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup our three spin boxes.
			//............................
			hMyBuddy2 = GetDlgItem(hDlg,IDC_BUDDY2);
			hMyBuddy3 = GetDlgItem(hDlg,IDC_BUDDY3);
			hMyBuddy4 = GetDlgItem(hDlg,IDC_BUDDY4);
			dwStyle = UDS_WRAP | UDS_ARROWKEYS | UDS_ALIGNRIGHT | UDS_SETBUDDYINT | UDS_NOTHOUSANDS;
			hSpinBox2 = CreateMySpinBox(dwStyle,0,0,8,8,hDlg,IDC_MODN,
										hMyBuddy2,16384,480,2600);
			hSpinBox3 = CreateMySpinBox(dwStyle,0,0,8,8,hDlg,IDC_SEPARATION,hMyBuddy3,64,0,0);
			hSpinBox4 = CreateMySpinBox(dwStyle,0,0,8,8,hDlg,IDC_VP,hMyBuddy4,65535,0,0);

			// Set the text limits for the User ID and Pass Phrase.
			//....................................
			SendDlgItemMessage(hDlg,IDC_USERID,EM_SETLIMITTEXT,(WPARAM) 250,0);
			SendDlgItemMessage(hDlg,IDC_COPY1,EM_SETLIMITTEXT,(WPARAM) 250,0);
			SendDlgItemMessage(hDlg,IDC_COPY2,EM_SETLIMITTEXT,(WPARAM) 250,0);

			// Check the forever radiobutton.
			//...............................
			CheckRadioButton(hDlg,IDC_FOREVER,IDC_SETDAYS,IDC_FOREVER);

			// Check the normal priority radiobutton.
			//.......................................
			CheckRadioButton(hDlg,IDC_IDLE,IDC_REALTIME,IDC_NORMAL);
			dwKeyGenPriority = NORMAL_PRIORITY_CLASS;

			// If we have WinNT or Win 2000 disable the realtime
			// priority button.
			//..................................................
			if (bIsWinNT)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_REALTIME),FALSE);
			}
			// Set the text limit for the numbers.
			//....................................
			SendDlgItemMessage(hDlg,IDC_BUDDY4,EM_SETLIMITTEXT,(WPARAM)5,0);
			SendDlgItemMessage(hDlg,IDC_BUDDY2,EM_SETLIMITTEXT,(WPARAM)5,0);
			SendDlgItemMessage(hDlg,IDC_BUDDY3,EM_SETLIMITTEXT,(WPARAM)2,0);

			ZeroMemory(&szTemp1,sizeof(szTemp1));
			ZeroMemory(&szTemp2,sizeof(szTemp2));

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));

			if (!hSpinBox2 || !hSpinBox3 || !hSpinBox4)
			{
				return(FALSE);
			}
			else
			{
				return(TRUE);
			}
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_FOREVER:
				{
					SetDlgItemInt(hDlg,IDC_BUDDY4,0,FALSE);
					EnableWindow(GetDlgItem(hDlg,IDC_BUDDY4),FALSE);
					CheckRadioButton(hDlg,IDC_FOREVER,IDC_SETDAYS,IDC_FOREVER);
				}
				break;

				case IDC_SETDAYS:
				{
					EnableWindow(GetDlgItem(hDlg,IDC_BUDDY4),TRUE);
					CheckRadioButton(hDlg,IDC_FOREVER,IDC_SETDAYS,IDC_SETDAYS);
				}
				break;

				case IDC_IDLE:
				{
					CheckRadioButton(hDlg,IDC_IDLE,IDC_REALTIME,IDC_IDLE);
					dwKeyGenPriority = IDLE_PRIORITY_CLASS;
				}
				break;

				case IDC_NORMAL:
				{
					CheckRadioButton(hDlg,IDC_IDLE,IDC_REALTIME,IDC_NORMAL);
					dwKeyGenPriority = NORMAL_PRIORITY_CLASS;
				}
				break;

				case IDC_HIGH:
				{
					CheckRadioButton(hDlg,IDC_IDLE,IDC_REALTIME,IDC_HIGH);
					dwKeyGenPriority = HIGH_PRIORITY_CLASS;
				}
				break;

				case IDC_REALTIME:
				{
					CheckRadioButton(hDlg,IDC_IDLE,IDC_REALTIME,IDC_REALTIME);
					dwKeyGenPriority = REALTIME_PRIORITY_CLASS;
				}
				break;

				case IDC_COPY1TEXT:
				{
					VirtualKeyboard(hDlg,IDC_COPY1,(LPBYTE)&szPassPhrase1,
									sizeof(szPassPhrase1));
					SetFocus(GetDlgItem(hDlg,IDC_COPY1));
				}
				break;

				case IDC_COPY2TEXT:
				{
					VirtualKeyboard(hDlg,IDC_COPY2,(LPBYTE)&szPassPhrase2,
									sizeof(szPassPhrase2));
					SetFocus(GetDlgItem(hDlg,IDC_COPY2));
				}
				break;

				case IDOK:
				{	
					// Retrieve what we have entered in the dialogbox.
					//................................................
					GetDlgItemText(hDlg,IDC_USERID,szUserID,sizeof(szUserID)-1);
					GetDlgItemText(hDlg,IDC_COPY1,szTemp1,sizeof(szTemp1)-1);
					GetDlgItemText(hDlg,IDC_COPY2,szTemp2,sizeof(szTemp2)-1);
					dwN_Bits = GetDlgItemInt(hDlg,IDC_BUDDY2,&bError,FALSE);
					dwSeparationBits = GetDlgItemInt(hDlg,IDC_BUDDY3,&bError,FALSE);
					dwValidityPeriod = GetDlgItemInt(hDlg,IDC_BUDDY4,&bError,FALSE);

					iLengthOfUserId = lstrlen(szUserID);

					// We did not enter a User ID.
					//............................
					if (iLengthOfUserId == 0)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_NOUSERID,
									   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
						SetFocus(GetDlgItem(hDlg,IDC_USERID));
						break;
					}
					iLengthOfPassPhrase = lstrlen(szTemp1);
					dwLengthPP2 = lstrlen(szTemp2);

					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,iLengthOfPassPhrase
						mov		edi,offset szTemp1
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (i = 0; i < iLengthOfPassPhrase; i++)
						{
							if ((BYTE)szTemp1[i] != DEFAULT_CHAR)
							{
								szPassPhrase1[i] = szTemp1[i];
							}
						}
					}
					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP2
						mov		edi,offset szTemp2
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP2; dwV++)
						{
							if ((BYTE)szTemp2[dwV] != DEFAULT_CHAR)
							{
								szPassPhrase2[dwV] = szTemp2[dwV];
							}
						}
					}
					// Check out the Pass Phrase.
					//...........................
					iCompareResult = lstrcmp(szPassPhrase1,szPassPhrase2);

					if (iCompareResult != 0)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_PPDIFF,MB_ICONHAND | MB_OK,
									   MB_ICONHAND,0);
						SetDlgItemText(hDlg,IDC_COPY1,lpszNullString);
						SetDlgItemText(hDlg,IDC_COPY2,lpszNullString);
						ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));
						ZeroMemory(&szPassPhrase2,sizeof(szPassPhrase2));
						ZeroMemory(&szTemp1,sizeof(szTemp1));
						ZeroMemory(&szTemp2,sizeof(szTemp2));
						SetFocus(GetDlgItem(hDlg,IDC_COPY1));
						break;
					}
					// Check out the validity period.
					//...............................
					if (dwValidityPeriod > 65535)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_VALIDITYPERIOD,
									   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
						SetFocus(GetDlgItem(hDlg,IDC_BUDDY4));
						break;
					}
					// Check out Modulus n bits.
					//..........................
					if (dwN_Bits < MIN_BITS || dwN_Bits > MAX_BITS)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_MODNBITS,
									   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
						SetFocus(GetDlgItem(hDlg,IDC_BUDDY2));
						break;
					}
					// Check out the separation bits.
					//...............................
					if (dwSeparationBits > MAX_SEP_BITS)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_SEPARATIONBITS,
									   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
						SetFocus(GetDlgItem(hDlg,IDC_BUDDY3));
						break;
					}

					if (iLengthOfPassPhrase == 0)
					{
						// If we have an administrator account we need a pass phrase.
						//...........................................................
						if (bAa)
						{
							MessageBoxProc(hDlg,IDS_ADVISORY,IDS_PP_REQUIRED,
										   MB_ICONHAND | MB_OK,MB_ICONSTOP,0);
							SetDlgItemText(hDlg,IDC_COPY1,lpszNullString);
							SetDlgItemText(hDlg,IDC_COPY2,lpszNullString);
							ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));
							ZeroMemory(&szPassPhrase2,sizeof(szPassPhrase2));
							ZeroMemory(&szTemp1,sizeof(szTemp1));
							ZeroMemory(&szTemp2,sizeof(szTemp2));
							SetFocus(GetDlgItem(hDlg,IDC_COPY1));
							break;
						}
						else
						{
							MessageBoxProc(hDlg,IDS_ADVISORY,IDS_NOPP,
										   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
						}
					}
					// Set the pass phrase edit boxes to null strings.
					//................................................
					SetDlgItemText(hDlg,IDC_COPY1,lpszNullString);
					SetDlgItemText(hDlg,IDC_COPY2,lpszNullString);
					ZeroMemory(&szTemp1,sizeof(szTemp1));
					ZeroMemory(&szTemp2,sizeof(szTemp2));
					EndDialog(hDlg,IDOK);
				}
				break;
				
				case IDCANCEL:
				{
					// Set the pass phrase edit boxes to null strings.
					//................................................
					SetDlgItemText(hDlg,IDC_COPY1,lpszNullString);
					SetDlgItemText(hDlg,IDC_COPY2,lpszNullString);
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_RSARESET:
				{
					SetDlgItemText(hDlg,IDC_USERID,lpszNullString);
					SetDlgItemText(hDlg,IDC_COPY1,lpszNullString);
					SetDlgItemText(hDlg,IDC_COPY2,lpszNullString);
					ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));
					ZeroMemory(&szPassPhrase2,sizeof(szPassPhrase2));
					SetDlgItemInt(hDlg,IDC_BUDDY2,2600,FALSE);
					SetDlgItemInt(hDlg,IDC_BUDDY3,0,FALSE);
					CheckRadioButton(hDlg,IDC_FOREVER,IDC_SETDAYS,IDC_FOREVER);
					SetDlgItemInt(hDlg,IDC_BUDDY4,0,FALSE);
					EnableWindow(GetDlgItem(hDlg,IDC_BUDDY4),FALSE);
					CheckRadioButton(hDlg,IDC_IDLE,IDC_REALTIME,IDC_NORMAL);
					dwKeyGenPriority = NORMAL_PRIORITY_CLASS;
					SetFocus(GetDlgItem(hDlg,IDC_USERID));
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Prime p fermat test progress function.
//.......................................
VOID PrimePFermatProgress()
{
	int	iRadioButton = IDC_RADIOP1;

	// Clear all the radiobuttons.
	//............................
	if (dwFermatNumber == -1)
	{
		CheckDlgButton(hDialogModeLess,IDC_RADIOP1,BST_UNCHECKED);
		CheckDlgButton(hDialogModeLess,IDC_RADIOP2,BST_UNCHECKED);
		CheckDlgButton(hDialogModeLess,IDC_RADIOP3,BST_UNCHECKED);
		CheckDlgButton(hDialogModeLess,IDC_RADIOP4,BST_UNCHECKED);
	}
	else
	{
		iRadioButton += dwFermatNumber;
		CheckDlgButton(hDialogModeLess,iRadioButton,BST_CHECKED);
	}
}

// Prime q fermat test progress function.
//.......................................
VOID PrimeQFermatProgress()
{
	int	iRadioButton = IDC_RADIOQ1;

	// Clear all the radiobuttons.
	//............................
	if (dwFermatNumber == -1)
	{
		CheckDlgButton(hDialogModeLess,IDC_RADIOQ1,BST_UNCHECKED);
		CheckDlgButton(hDialogModeLess,IDC_RADIOQ2,BST_UNCHECKED);
		CheckDlgButton(hDialogModeLess,IDC_RADIOQ3,BST_UNCHECKED);
		CheckDlgButton(hDialogModeLess,IDC_RADIOQ4,BST_UNCHECKED);
	}
	else
	{
		iRadioButton += dwFermatNumber;
		CheckDlgButton(hDialogModeLess,iRadioButton,BST_CHECKED);
	}
}

// Prime p status information.
//............................
VOID PrimePStatus()
{
	TCHAR	cBuffer[24];

	if (dwNumbersTested)
	{
		FormatMyNumber(dwNumbersTested,(LPTSTR)&cBuffer,sizeof(cBuffer));
		SetDlgItemText(hDialogModeLess,IDC_NUMBERSTESTEDP,cBuffer);
	}
	if (dwFermatFail)
	{
		FormatMyNumber(dwFermatFail,(LPTSTR)&cBuffer,sizeof(cBuffer));
		SetDlgItemText(hDialogModeLess,IDC_FAILEDP,cBuffer);
	}
}

// Prime q status information.
//............................
VOID PrimeQStatus()
{
	TCHAR	cBuffer[24];

	if (dwNumbersTested)
	{
		FormatMyNumber(dwNumbersTested,(LPTSTR)&cBuffer,sizeof(cBuffer));
		SetDlgItemText(hDialogModeLess,IDC_NUMBERSTESTEDQ,cBuffer);
	}
	if (dwFermatFail)
	{
		FormatMyNumber(dwFermatFail,(LPTSTR)&cBuffer,sizeof(cBuffer));
		SetDlgItemText(hDialogModeLess,IDC_FAILEDQ,cBuffer);
	}
}

// Find a large random prime number. Returns FALSE if error or quit.
// Returns bits, bytes, and dwords in appropriate places.
//..................................................................
BOOL GetRandomPrimeNumber(LPBYTE lpPrimeSuspect, DWORD dwBitsRequired)
{
	DWORD	dwPDelta;
	DWORD	dwPrimeBytes;
	DWORD	dwPrimeBits;
	DWORD	dwPrimeDwords;
	BOOL	bGoodPrime = FALSE;
	BOOL	bPassed;
	TCHAR	szBuffer[100];

	StirTheBits();

	// Get a random set of bits for our starting prime suspect.
	//.........................................................
	GetRandomBits(dwBitsRequired,lpPrimeSuspect);

	// Ensure the least and two most significant bits are set in
	// the prime suspect. This is to ensure a Modulus n of a
	// specified length.
	//..........................................................
	__asm
	{
		mov		edi,lpPrimeSuspect
		bts		dword ptr [edi],0
		mov		ecx,dwBitsRequired
		dec		ecx				// 0 based
		push	ecx
		mov		ebx,ecx
		shr		ebx,3			// Byte position in string
		and		ecx,07h			// Bit position in byte
		mov		eax,dword ptr [edi][ebx]
		bts		eax,ecx
		mov		dword ptr [edi][ebx],eax
		pop		ecx
		dec		ecx
		mov		ebx,ecx
		shr		ebx,3			// Byte position in string
		and		ecx,07h			// Bit position in byte
		mov		eax,dword ptr [edi][ebx]
		bts		eax,ecx
		mov		dword ptr [edi][ebx],eax
	}
	// Count the number of bits, bytes, and dwords.
	//.............................................
	CountBBD(lpPrimeSuspect,MAX_PRIME_BYTES);
	dwPrimeBits = dwCountBits;
	dwPrimeBytes = dwCountBytes;
	dwPrimeDwords = dwCountDwords;

	// Stir up the bits in the random bits bin.
	//.........................................
	StirTheBits();

	// See if we want to quit.
	//........................
	CheckForMessages();
	if (bCancelOperation)
	{
		goto EndTest;
	}
	// Setup the remainders table for our suspected prime.
	//....................................................
	LoadString(hInst,IDS_REMAINDERSTABLE,szBuffer,sizeof(szBuffer));
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,szBuffer);
	BuildSieve(lpPrimeSuspect,dwCountBits,lpPrimesTable,lpRemaindersTable,PRIMES_IN_TABLE);
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,lpszNullString);

	// See if we want to quit.
	//........................
	CheckForMessages();
	if (bCancelOperation)
	{
		goto EndTest;
	}
	// Stir the bits again.
	//.....................
	StirTheBits();

	// Suspend our Random Bits Bin thread and DCT thread.
	//...................................................
	SuspendThread(hRBBThread);
	bRBBThreadSuspended = TRUE;
	SuspendThread(hDCTThread);
	bDCTThreadSuspended = TRUE;

	// Inform we are conducting fast sieve and fermat tests.
	//......................................................
	LoadString(hInst,IDS_FERMATTESTS,szBuffer,sizeof(szBuffer));
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,szBuffer);

	// Now we set up for the fast sieve that does a prelimary test
	// to see if our suspect might be a prime number. If it passed
	// the fast sieve we do four Fermat Tests to make sure it is
	// prime.
	//............................................................
	dwPDelta = 0;
	while (dwPDelta < MAX_TEST_PRIME)
	{
		CheckForMessages();
		if (bCancelOperation)
		{
			goto EndTest;
		}
		// Print our status in the dialog box.
		//....................................
		dwNumbersTested++;
		if (bTestingPrimeP)
		{
			PrimePStatus();
		}
		else
		{
			PrimeQStatus();
		}
		bPassed = FastSieve(dwPDelta,lpPrimesTable,lpRemaindersTable);

		CheckForMessages();
		if (bCancelOperation)
		{
			goto EndTest;
		}
		// If it passed the FastSieve perform the Fermat Tests.
		//.....................................................
		if (bPassed)
		{
			bPassed = FermatTest(lpPrimeSuspect,lpPrimesTable,dwCountBytes);

			// We passed the Fermat Tests.
			//............................
			if (bPassed)
			{
				SetDlgItemText(hDialogModeLess,IDC_MESSAGE,lpszNullString);
				bGoodPrime = TRUE;
				ResumeThread(hRBBThread);
				bRBBThreadSuspended = FALSE;
				ResumeThread(hDCTThread);
				bDCTThreadSuspended = FALSE;
				goto EndTest;
			}
			dwFermatFail++;
		}
		// The number failed the fast sieve or the fermat tests.
		// Display progress and continue with next number.
		//......................................................
		if (bTestingPrimeP)
		{
			PrimePStatus();
		}
		else
		{
			PrimeQStatus();
		}
		// Only clear the Fermat Test indicators if we
		// have some set.
		//............................................
		if (dwFermatNumber != -1)
		{
			dwFermatNumber = -1;
			if (bTestingPrimeP)
			{
				PrimePFermatProgress();
			}
			else
			{
				PrimeQFermatProgress();
			}
		}
		// Add two to the prime suspect and try again.
		//............................................
		dwPDelta += 2;
		MpIncDW(lpPrimeSuspect,dwPrimeDwords);
		CountBBD(lpPrimeSuspect,MAX_PRIME_BYTES);
		MpIncDW(lpPrimeSuspect,dwCountDwords);
		CountBBD(lpPrimeSuspect,MAX_PRIME_BYTES);
		dwPrimeBits = dwCountBits;
		dwPrimeBytes = dwCountBytes;
		dwPrimeDwords = dwCountDwords;
	}
	// If we ran out of numbers we have to quit.
	//..........................................
	if (dwPDelta >= MAX_TEST_PRIME)
	{
		ResetProgramPriority();

		MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NOFINDPRIME,
					   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
	}

	EndTest:
	dwCountBits = dwPrimeBits;
	dwCountBytes = dwPrimeBytes;
	dwCountDwords = dwPrimeDwords;
	return(bGoodPrime);
}

// Reset the programs priority to normal if it is not normal.
//...........................................................
VOID ResetProgramPriority()
{
	if (dwKeyGenPriority != NORMAL_PRIORITY_CLASS)
	{
		// Set our process back to normal.
		//................................
		SetPriorityClass(GetCurrentProcess(),NORMAL_PRIORITY_CLASS);

		// If we were running in Realtime priority enable the main window.
		//................................................................
		if (dwKeyGenPriority == REALTIME_PRIORITY_CLASS)
		{
			EnableWindow(hMainWindow,TRUE);
		}
		dwKeyGenPriority = NORMAL_PRIORITY_CLASS;	
	}
}
